/**************************************************************************************

Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.

***************************************************************************************

  $Id: WatchdogDlg.h 12626 2018-10-30 14:55:29Z LuisContreras $:

  Description:
    Watchdog trigger dialog

  Changes:
    Date        Description
    -----------------------------------------------------------------------------------
    2010-04-29  Updated to latest cifXUser / stdint.h
    2006-07-04  initial version

**************************************************************************************/

/////////////////////////////////////////////////////////////////////////////
/// \file WatchdogDlg.h
///   Watchdog trigger dialog
/////////////////////////////////////////////////////////////////////////////

#pragma once

#include "BaseDialog.h"
#include <stdint.h>


///////////////////////////////////////////////////////////////////////////////////////////
/// Watchdog trigger dialog
///////////////////////////////////////////////////////////////////////////////////////////
class CWatchdogDlg : public CBaseDialog
{
	DECLARE_DYNAMIC(CWatchdogDlg)

public:
	CWatchdogDlg(CWnd* pParent = NULL);   // standard constructor
	virtual ~CWatchdogDlg();

// Dialog Data
	enum { IDD = IDD_WATCHDOG };

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

  uint32_t  m_ulLastTriggerValue;   //!< Last returned Watchdogvalue
  bool      m_fTriggerWatchdog;     //!< true if watchdog trigger is running

	DECLARE_MESSAGE_MAP()
public:
  virtual BOOL OnInitDialog();
  afx_msg void OnBnClickedBtnStartstop();
  void ThreadFunction(void);
  void OnUpdateDevice(CCifXDeviceBase* pcDevice);

  afx_msg void OnEnKillfocusEdtTriggerinterval();
};
